


load('hiscaledir_apr28.mat');
load('hiscaledir_may05.mat');
load('hiscaledir_may14.mat');
load('hiscaledir_may02.mat');
load('hiscaledir_may10.mat');

sizecell = cell(1,5);
totccell = cell(1,5);


[totcvec_apr28, sizevec_apr28] = makingvecs(hiscaledir_apr28);
[totcvec_may05, sizevec_may05] = makingvecs(hiscaledir_may05);
[totcvec_may14, sizevec_may14] = makingvecs(hiscaledir_may14);
[totcvec_may02, sizevec_may02] = makingvecs(hiscaledir_may02);
[totcvec_may10, sizevec_may10] = makingvecs(hiscaledir_may10);

totccell{1} = totcvec_apr28;
totccell{2} = totcvec_may05;
totccell{3} = totcvec_may14;
totccell{4} = totcvec_may02;
totccell{5} = totcvec_may10;

sizecell{1} = sizevec_apr28;
sizecell{2} = sizevec_may05;
sizecell{3} = sizevec_may14;
sizecell{4} = sizevec_may02;
sizecell{5} = sizevec_may10;
	
hiscale_plotting_sizevcabs;

function [totcvec, sizevec] = makingvecs(dirlist)
totcvec = [];
sizevec = [];
for i = 1:length(dirlist)
	load(dirlist{i});
	
	
	for k = 1:max(max(Snew.LabelMat))
		partmask = zeros(size(Snew.LabelMat));
		partmask(Snew.LabelMat==k) = 1;
		
		[~,preim_idx] = min(abs(Snew.eVenergy - 278));
		[~,postim_idx] = min(abs(Snew.eVenergy - 320));
		preim = Snew.spectr(:,:,preim_idx);
		postim = Snew.spectr(:,:,postim_idx);
		
		prepost = postim - preim;
		prepost(prepost < 0) = 0;
		
		%thickmap = Snew.ThickMap(:,:,1) + Snew.ThickMap(:,:,2) + Snew.ThickMap(:,:,3);
		%currTotC = thickmap .* partmask;
		%currthickness(k,1) = max(max(currTotC));
		%curr_totcvec(k,1) = currthickness(k,1) ./ Snew.Size(k);
		
		
		currTotC = prepost .* partmask;
		
		curr_totcvec(k,1) = max(max(currTotC));
		
		
	end
	
	totcvec = [totcvec ; curr_totcvec];
	sizevec = [sizevec , Snew.Size];
	
	clear curr_totcvec
	
	
	
end

end